package com.sg.baseclass;

import com.sg.driver.CucumberTestRunner;
import com.sg.pages.LoginPage;
import com.sg.pages.UsersPage;
import io.cucumber.datatable.DataTable;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.testng.Assert;
import java.util.List;
import java.util.Map;

public class UserModuleBaseClass extends CucumberTestRunner {

    public boolean verifyLaunchBrowser(String browserName){
        WebDriver oBrowser = null;
        try{
            oBrowser = appInd.launchBrowser(browserName);
            return true;
        }catch(Exception e){
            report.writeReport(null, "Exception", "Exception in 'verifyLaunchBrowser()' method. " + e);
            return false;
        }
    }

    public boolean verifyUserNavigatesURL(WebDriver oBrowser, DataTable dataTable){
        List<Map<String, String>> inputData = null;
        try{
            inputData = dataTable.asMaps(String.class, String.class);
            appDep.navigateURL(oBrowser, inputData.get(0).get("url"), inputData.get(0).get("pageTitle"));
            return true;
        }catch(Exception e){
            report.writeReport(null, "Exception", "Exception in 'verifyUserNavigatesURL()' method. " + e);
            return false;
        }
    }


    public boolean enterUserName(WebDriver oBrowser, String userName){
        try{
            return appInd.setObject(oBrowser, LoginPage.obj_UserName_Edit, userName);
        }catch(Exception e){
            report.writeReport(null, "Exception", "Exception in 'enterUserName()' method. " + e);
            return false;
        }
    }


    public boolean enterPassword(WebDriver oBrowser, String password){
        try{
            return appInd.setObject(oBrowser, LoginPage.obj_Password_Edit, password);
        }catch(Exception e){
            report.writeReport(null, "Exception", "Exception in 'enterPassword()' method. " + e);
            return false;
        }
    }


    /****************************************************
     * Method Name      : createUser()
     * purpose          : it will create the new user in ActiTime
     * Author           : tester1
     * Parameters       : WebDriver
     * Call Statement   : String userName = createUser(oBrowser);
     * Return Type      : boolean
     ******************************************************/
    public String createUser(WebDriver oBrowser, Map<String, String> data){
        String userName = null;
        try{
            Assert.assertTrue(appInd.clickObject(oBrowser, UsersPage.obj_USERS_Tab));
            appInd.waitForElement(oBrowser, UsersPage.obj_AddUser_Button, "Clickable", "", 10);

            Assert.assertTrue(appInd.clickObject(oBrowser, UsersPage.obj_AddUser_Button));
            appInd.waitForElement(oBrowser, UsersPage.obj_CreateUser_Button, "Clickable", "", 10);

            //enter required details to create the new user
            Assert.assertTrue(appInd.setObject(oBrowser, UsersPage.obj_User_FirstName_Edit, data.get("User_FirstName")));
            Assert.assertTrue(appInd.setObject(oBrowser, UsersPage.obj_User_LastName_Edit, data.get("User_LastName")));
            Assert.assertTrue(appInd.setObject(oBrowser, UsersPage.obj_User_Email_Edit, data.get("User_Email")));
            Assert.assertTrue(appInd.setObject(oBrowser, UsersPage.obj_User_UserName_Edit, data.get("User_UserName")));
            Assert.assertTrue(appInd.setObject(oBrowser, UsersPage.obj_User_Password_Edit, data.get("User_Password")));
            Assert.assertTrue(appInd.setObject(oBrowser, UsersPage.obj_User_RetypePassword_Edit, data.get("User_RetypePassword")));
            Assert.assertTrue(appInd.clickObject(oBrowser, UsersPage.obj_CreateUser_Button));
            userName = data.get("User_LastName") + ", " + data.get("User_FirstName");
            appInd.waitForElement(oBrowser, By.xpath(String.format(UsersPage.obj_UserName_Link, userName)), "Text", userName, 10);
            appInd.waitForElement(oBrowser, By.xpath(String.format(UsersPage.obj_UserName_Link, userName)), "Clickable", "", 20);

            boolean blnRes = appInd.verifyElementPresent(oBrowser, By.xpath(String.format(UsersPage.obj_UserName_Link, userName)));
            if(blnRes == true){
                report.writeReport(oBrowser, "Pass", "The new user created successful");
                return userName;
            }else{
                System.out.println();
                report.writeReport(oBrowser, "Fail", "Failed to create the new user.");
                return null;
            }
        }catch(Exception e){
            report.writeReport(oBrowser, "Exception", "Exception in 'createUser()' method: " + e.getMessage());
            return null;
        }
    }


    /****************************************************
     * Method Name      : deleteUser()
     * purpose          : it will delete the user in ActiTime
     * Author           : tester1
     * Parameters       : WebDriver
     * Call Statement   : deleteUser(oBrowser, "User1, SG");
     * Return Type      : boolean
     ******************************************************/
    public boolean deleteUser(WebDriver oBrowser, String userName){
        try{
            appInd.waitForElement(oBrowser, By.xpath(String.format(UsersPage.obj_UserName_Link, userName)), "Clickable", "", 20);
            appInd.clickObject(oBrowser, By.xpath(String.format(UsersPage.obj_UserName_Link, userName)));
            appInd.waitForElement(oBrowser, UsersPage.obj_DeleteUser_Button, "Clickable", "", 10);
            appInd.clickObject(oBrowser, UsersPage.obj_DeleteUser_Button);
            appInd.threadSleep(2000);
            oBrowser.switchTo().alert().accept();
            appInd.threadSleep(1000);

            //verify user deleted successful
            appInd.waitForElement(oBrowser, By.xpath(String.format(UsersPage.obj_UserName_Link, userName)), "Invisible", "", 10);
            boolean blnRes = appInd.verifyElementNotPresent(oBrowser, By.xpath(String.format(UsersPage.obj_UserName_Link, userName)));

            if(blnRes == true) {
                report.writeReport(oBrowser, "Pass", "User deleted successful");
                return true;
            }else {
                report.writeReport(oBrowser, "Fail", "Failed to delete the user");
                return false;
            }
        }catch(Exception e){
            report.writeReport(oBrowser, "Exception", "Exception in 'deleteUser()' method: " + e.getMessage());
            return false;
        }
    }
}
